/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.ValueOverflow;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.vsp00.DataType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

class TimestampTranslator
extends CharDataTranslator {
    public static final long day0 = new Time(0, 0, 0).getTime();
    public static final long day1 = new Time(23, 59, 59).getTime();
    public static final String zeroPadC = "0000";
    private static final int TimestampSize_C = 26;

    protected TimestampTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getTimestamp(sQLParamController, structuredMem, null);
    }

    public java.sql.Date getDate(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(sQLParamController, structuredMem, calendar);
        java.sql.Date date = null;
        if (timestamp != null) {
            date = new java.sql.Date(timestamp.getTime());
        }
        return date;
    }

    public Time getTime(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(sQLParamController, structuredMem, calendar);
        Time time = null;
        if (timestamp != null) {
            time = new Time(timestamp.getTime());
        }
        return time;
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getString(this.bufpos, this.physicalLength - 1);
        }
        return string;
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.physicalLength - 1);
            int n = (byArray[0] - 48) * 1000;
            n += (byArray[1] - 48) * 100;
            n += (byArray[2] - 48) * 10;
            n += byArray[3] - 48;
            int n2 = (byArray[5] - 48) * 10;
            n2 += byArray[6] - 48;
            int n3 = (byArray[8] - 48) * 10;
            n3 += byArray[9] - 48;
            int n4 = (byArray[11] - 48) * 10;
            n4 += byArray[12] - 48;
            int n5 = (byArray[14] - 48) * 10;
            n5 += byArray[15] - 48;
            int n6 = (byArray[17] - 48) * 10;
            n6 += byArray[18] - 48;
            int n7 = (byArray[20] - 48) * 100;
            n7 += (byArray[21] - 48) * 10;
            int n8 = ((n7 += byArray[22] - 48) * 10 + (byArray[23] - 48)) * 100;
            n8 += (byArray[24] - 48) * 10;
            n8 += byArray[25] - 48;
            n8 *= 1000;
            if (calendar == null) {
                timestamp = new Timestamp(n - 1900, n2 - 1, n3, n4, n5, n6, n8);
            } else {
                calendar.clear();
                calendar.set(n, n2 - 1, n3, n4, n5, n6);
                timestamp = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(calendar, n8);
            }
        }
        return timestamp;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return this.transTimestampForInput(Timestamp.valueOf(string), Calendar.getInstance());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                java.sql.Date date = java.sql.Date.valueOf(string);
                return this.transTimestampForInput(new Timestamp(date.getTime()), Calendar.getInstance());
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    Time time = Time.valueOf(string);
                    return this.transTimestampForInput(new Timestamp(time.getTime()), Calendar.getInstance());
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    throw this.newParseException(string, "Timestamp");
                }
            }
        }
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof Timestamp) {
            object2 = this.transTimestampForInput((Timestamp)object, Calendar.getInstance());
        } else if (object instanceof Time) {
            String string = ((Time)object).toString();
            String string2 = new java.sql.Date(new Date().getTime()).toString();
            String string3 = string2 + " " + string + ".0";
            Timestamp timestamp = Timestamp.valueOf(string3);
            object2 = this.transTimestampForInput(timestamp, Calendar.getInstance());
        } else if (object instanceof java.sql.Date) {
            String string = ((java.sql.Date)object).toString();
            String string4 = string + " 00:00:00.0";
            Timestamp timestamp = Timestamp.valueOf(string4);
            object2 = this.transTimestampForInput(timestamp, Calendar.getInstance());
        } else if (object instanceof Date) {
            Date date = (Date)object;
            object2 = this.transTimestampForInput(new Timestamp(date.getTime()), Calendar.getInstance());
        } else if (object instanceof String) {
            String string = (String)object;
            object2 = this.transStringForInput(string);
        }
        return object2;
    }

    public Object transTimestampForInput(Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        calendar.setTime(timestamp);
        byte[] byArray = new byte[26];
        int n = calendar.get(1);
        if (n < 0 || n > 9999) {
            throw this.newParseException(timestamp.toString(), "Timestamp");
        }
        byArray[0] = (byte)(48 + n / 1000);
        byArray[1] = (byte)(48 + (n %= 1000) / 100);
        byArray[2] = (byte)(48 + (n %= 100) / 10);
        byArray[3] = (byte)(48 + (n %= 10));
        byArray[4] = 45;
        n = calendar.get(2) + 1;
        byArray[5] = CharDataTranslator.HighTime_C[n];
        byArray[6] = CharDataTranslator.LowTime_C[n];
        byArray[7] = 45;
        n = calendar.get(5);
        byArray[8] = CharDataTranslator.HighTime_C[n];
        byArray[9] = CharDataTranslator.LowTime_C[n];
        byArray[10] = 32;
        n = calendar.get(11);
        byArray[11] = CharDataTranslator.HighTime_C[n];
        byArray[12] = CharDataTranslator.LowTime_C[n];
        byArray[13] = 58;
        n = calendar.get(12);
        byArray[14] = (byte)(48 + n / 10);
        byArray[15] = (byte)(48 + n % 10);
        byArray[16] = 58;
        n = calendar.get(13);
        byArray[17] = (byte)(48 + n / 10);
        byArray[18] = (byte)(48 + n % 10);
        byArray[19] = 46;
        n = timestamp.getNanos() / 1000;
        byArray[20] = (byte)(48 + n / 100000);
        byArray[21] = (byte)(48 + (n %= 100000) / 10000);
        byArray[22] = (byte)(48 + (n %= 10000) / 1000);
        byArray[23] = (byte)(48 + (n %= 1000) / 100);
        byArray[24] = (byte)(48 + (n %= 100) / 10);
        byArray[25] = (byte)(48 + (n %= 10));
        return byArray;
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        byte[] byArray = (byte[])object;
        if (byArray.length > this.physicalLength - 1) {
            throw new ValueOverflow(DataType.stringValuesC[this.dataType], -1);
        }
        dataPart.putInt1(32, this.bufpos - 1);
        dataPart.putStringBytes(byArray, this.bufpos, this.physicalLength - 1);
    }
}

