use strict;
use warnings;
use Test::More;
use String::ToIdentifier::EN ();
use String::ToIdentifier::EN::Unicode ();

plan tests => (128 * 3) * 2;

sub is_both;

# First as CamelCase.

is_both ["\x00"], 'null', 'null';
is_both ["\x01"], 'startOfHeading', 'startOfHeading';
is_both ["\x02"], 'startOfText', 'startOfText';
is_both ["\x03"], 'endOfText', 'endOfText';
is_both ["\x04"], 'endOfTransmission', 'endOfTransmission';
is_both ["\x05"], 'enquiryChar', 'enquiryChar';
is_both ["\x06"], 'acknowledge', 'acknowledge';
is_both ["\x07"], 'bellChar', 'bellChar';
is_both ["\x08"], 'backspace', 'backspace';
is_both ["\x09"], 'tabChar', 'tabChar';
is_both ["\x0A"], 'newline', 'newline';
is_both ["\x0B"], 'verticalTab', 'verticalTab';
is_both ["\x0C"], 'formFeed', 'formFeed';
is_both ["\x0D"], 'carriageReturn', 'carriageReturn';
is_both ["\x0E"], 'shiftOut', 'shiftOut';
is_both ["\x0F"], 'shiftIn', 'shiftIn';
is_both ["\x10"], 'dataLinkEscape', 'dataLinkEscape';
is_both ["\x11"], 'deviceControl1', 'deviceControl1';
is_both ["\x12"], 'deviceControl2', 'deviceControl2';
is_both ["\x13"], 'deviceControl3', 'deviceControl3';
is_both ["\x14"], 'deviceControl4', 'deviceControl4';
is_both ["\x15"], 'negativeAcknowledge', 'negativeAcknowledge';
is_both ["\x16"], 'synchronousIdle', 'synchronousIdle';
is_both ["\x17"], 'endOfTransmissionBlock', 'endOfTransmissionBlock';
is_both ["\x18"], 'cancelChar', 'cancelChar';
is_both ["\x19"], 'endOfMedium', 'endOfMedium';
is_both ["\x1A"], 'substituteChar', 'substituteChar';
is_both ["\x1B"], 'escapeChar', 'escapeChar';
is_both ["\x1C"], 'fileSeparator', 'fileSeparator';
is_both ["\x1D"], 'groupSeparator', 'groupSeparator';
is_both ["\x1E"], 'recordSeparator', 'recordSeparator';
is_both ["\x1F"], 'unitSeparator', 'unitSeparator';
is_both ["\x20"], 'spaceChar', 'spaceChar';
is_both ["\x21"], 'exclamationMark', 'exclamationMark';
is_both ["\x22"], 'doubleQuote', 'doubleQuote';
is_both ["\x23"], 'hashMark', 'hashMark';
is_both ["\x24"], 'dollarSign', 'dollarSign';
is_both ["\x25"], 'percentSign', 'percentSign';
is_both ["\x26"], 'ampersand', 'ampersand';
is_both ["\x27"], 'singleQuote', 'singleQuote';
is_both ["\x28"], 'leftParen', 'leftParen';
is_both ["\x29"], 'rightParen', 'rightParen';
is_both ["\x2A"], 'asterisk', 'asterisk';
is_both ["\x2B"], 'plusSign', 'plusSign';
is_both ["\x2C"], 'comma', 'comma';
is_both ["\x2D"], 'dash', 'dash';
is_both ["\x2E"], 'dot', 'dot';
is_both ["\x2F"], 'slash', 'slash';
is_both ["\x30"], '0', 'digit zero';
is_both ["\x31"], '1', 'digit one';
is_both ["\x32"], '2', 'digit two';
is_both ["\x33"], '3', 'digit three';
is_both ["\x34"], '4', 'digit four';
is_both ["\x35"], '5', 'digit five';
is_both ["\x36"], '6', 'digit six';
is_both ["\x37"], '7', 'digit seven';
is_both ["\x38"], '8', 'digit eight';
is_both ["\x39"], '9', 'digit nine';
is_both ["\x3A"], 'colon', 'colon';
is_both ["\x3B"], 'semicolon', 'semicolon';
is_both ["\x3C"], 'leftAngleBracket', 'leftAngleBracket';
is_both ["\x3D"], 'equalsSign', 'equalsSign';
is_both ["\x3E"], 'rightAngleBracket', 'rightAngleBracket';
is_both ["\x3F"], 'questionMark', 'questionMark';
is_both ["\x40"], 'atSign', 'atSign';
is_both ["\x41"], 'a', 'A';
is_both ["\x42"], 'b', 'B';
is_both ["\x43"], 'c', 'C';
is_both ["\x44"], 'd', 'D';
is_both ["\x45"], 'e', 'E';
is_both ["\x46"], 'f', 'F';
is_both ["\x47"], 'g', 'G';
is_both ["\x48"], 'h', 'H';
is_both ["\x49"], 'i', 'I';
is_both ["\x4A"], 'j', 'J';
is_both ["\x4B"], 'k', 'K';
is_both ["\x4C"], 'l', 'L';
is_both ["\x4D"], 'm', 'M';
is_both ["\x4E"], 'n', 'N';
is_both ["\x4F"], 'o', 'O';
is_both ["\x50"], 'p', 'P';
is_both ["\x51"], 'q', 'Q';
is_both ["\x52"], 'r', 'R';
is_both ["\x53"], 's', 'S';
is_both ["\x54"], 't', 'T';
is_both ["\x55"], 'u', 'U';
is_both ["\x56"], 'v', 'V';
is_both ["\x57"], 'w', 'W';
is_both ["\x58"], 'x', 'X';
is_both ["\x59"], 'y', 'Y';
is_both ["\x5A"], 'z', 'Z';
is_both ["\x5B"], 'leftBracket', 'leftBracket';
is_both ["\x5C"], 'backslash', 'backslash';
is_both ["\x5D"], 'rightBracket', 'rightBracket';
is_both ["\x5E"], 'caret', 'caret';
is_both ["\x5F"], '_', '_';
is_both ["\x60"], 'backtick', 'backtick';
is_both ["\x61"], 'a', 'a';
is_both ["\x62"], 'b', 'b';
is_both ["\x63"], 'c', 'c';
is_both ["\x64"], 'd', 'd';
is_both ["\x65"], 'e', 'e';
is_both ["\x66"], 'f', 'f';
is_both ["\x67"], 'g', 'g';
is_both ["\x68"], 'h', 'h';
is_both ["\x69"], 'i', 'i';
is_both ["\x6A"], 'j', 'j';
is_both ["\x6B"], 'k', 'k';
is_both ["\x6C"], 'l', 'l';
is_both ["\x6D"], 'm', 'm';
is_both ["\x6E"], 'n', 'n';
is_both ["\x6F"], 'o', 'o';
is_both ["\x70"], 'p', 'p';
is_both ["\x71"], 'q', 'q';
is_both ["\x72"], 'r', 'r';
is_both ["\x73"], 's', 's';
is_both ["\x74"], 't', 't';
is_both ["\x75"], 'u', 'u';
is_both ["\x76"], 'v', 'v';
is_both ["\x77"], 'w', 'w';
is_both ["\x78"], 'x', 'x';
is_both ["\x79"], 'y', 'y';
is_both ["\x7A"], 'z', 'z';
is_both ["\x7B"], 'leftBrace', 'leftBrace';
is_both ["\x7C"], 'pipeChar', 'pipeChar';
is_both ["\x7D"], 'rightBrace', 'rightBrace';
is_both ["\x7E"], 'tilde', 'tilde';
is_both ["\x7F"], 'deleteChar', 'deleteChar';

# Now with a sep char.

is_both ["\x00", '_'], 'null', 'null';
is_both ["\x01", '_'], 'start_of_heading', 'start_of_heading';
is_both ["\x02", '_'], 'start_of_text', 'start_of_text';
is_both ["\x03", '_'], 'end_of_text', 'end_of_text';
is_both ["\x04", '_'], 'end_of_transmission', 'end_of_transmission';
is_both ["\x05", '_'], 'enquiry_char', 'enquiry_char';
is_both ["\x06", '_'], 'acknowledge', 'acknowledge';
is_both ["\x07", '_'], 'bell_char', 'bell_char';
is_both ["\x08", '_'], 'backspace', 'backspace';
is_both ["\x09", '_'], 'tab_char', 'tab_char';
is_both ["\x0A", '_'], 'newline', 'newline';
is_both ["\x0B", '_'], 'vertical_tab', 'vertical_tab';
is_both ["\x0C", '_'], 'form_feed', 'form_feed';
is_both ["\x0D", '_'], 'carriage_return', 'carriage_return';
is_both ["\x0E", '_'], 'shift_out', 'shift_out';
is_both ["\x0F", '_'], 'shift_in', 'shift_in';
is_both ["\x10", '_'], 'data_link_escape', 'data_link_escape';
is_both ["\x11", '_'], 'device_control1', 'device_control1';
is_both ["\x12", '_'], 'device_control2', 'device_control2';
is_both ["\x13", '_'], 'device_control3', 'device_control3';
is_both ["\x14", '_'], 'device_control4', 'device_control4';
is_both ["\x15", '_'], 'negative_acknowledge', 'negative_acknowledge';
is_both ["\x16", '_'], 'synchronous_idle', 'synchronous_idle';
is_both ["\x17", '_'], 'end_of_transmission_block', 'end_of_transmission_block';
is_both ["\x18", '_'], 'cancel_char', 'cancel_char';
is_both ["\x19", '_'], 'end_of_medium', 'end_of_medium';
is_both ["\x1A", '_'], 'substitute_char', 'substitute_char';
is_both ["\x1B", '_'], 'escape_char', 'escape_char';
is_both ["\x1C", '_'], 'file_separator', 'file_separator';
is_both ["\x1D", '_'], 'group_separator', 'group_separator';
is_both ["\x1E", '_'], 'record_separator', 'record_separator';
is_both ["\x1F", '_'], 'unit_separator', 'unit_separator';
is_both ["\x20", '_'], 'space_char', 'space_char';
is_both ["\x21", '_'], 'exclamation_mark', 'exclamation_mark';
is_both ["\x22", '_'], 'double_quote', 'double_quote';
is_both ["\x23", '_'], 'hash_mark', 'hash_mark';
is_both ["\x24", '_'], 'dollar_sign', 'dollar_sign';
is_both ["\x25", '_'], 'percent_sign', 'percent_sign';
is_both ["\x26", '_'], 'ampersand', 'ampersand';
is_both ["\x27", '_'], 'single_quote', 'single_quote';
is_both ["\x28", '_'], 'left_paren', 'left_paren';
is_both ["\x29", '_'], 'right_paren', 'right_paren';
is_both ["\x2A", '_'], 'asterisk', 'asterisk';
is_both ["\x2B", '_'], 'plus_sign', 'plus_sign';
is_both ["\x2C", '_'], 'comma', 'comma';
is_both ["\x2D", '_'], 'dash', 'dash';
is_both ["\x2E", '_'], 'dot', 'dot';
is_both ["\x2F", '_'], 'slash', 'slash';
is_both ["\x30", '_'], '0', 'digit zero';
is_both ["\x31", '_'], '1', 'digit one';
is_both ["\x32", '_'], '2', 'digit two';
is_both ["\x33", '_'], '3', 'digit three';
is_both ["\x34", '_'], '4', 'digit four';
is_both ["\x35", '_'], '5', 'digit five';
is_both ["\x36", '_'], '6', 'digit six';
is_both ["\x37", '_'], '7', 'digit seven';
is_both ["\x38", '_'], '8', 'digit eight';
is_both ["\x39", '_'], '9', 'digit nine';
is_both ["\x3A", '_'], 'colon', 'colon';
is_both ["\x3B", '_'], 'semicolon', 'semicolon';
is_both ["\x3C", '_'], 'left_angle_bracket', 'left_angle_bracket';
is_both ["\x3D", '_'], 'equals_sign', 'equals_sign';
is_both ["\x3E", '_'], 'right_angle_bracket', 'right_angle_bracket';
is_both ["\x3F", '_'], 'question_mark', 'question_mark';
is_both ["\x40", '_'], 'at_sign', 'at_sign';
is_both ["\x41", '_'], 'a', 'A';
is_both ["\x42", '_'], 'b', 'B';
is_both ["\x43", '_'], 'c', 'C';
is_both ["\x44", '_'], 'd', 'D';
is_both ["\x45", '_'], 'e', 'E';
is_both ["\x46", '_'], 'f', 'F';
is_both ["\x47", '_'], 'g', 'G';
is_both ["\x48", '_'], 'h', 'H';
is_both ["\x49", '_'], 'i', 'I';
is_both ["\x4A", '_'], 'j', 'J';
is_both ["\x4B", '_'], 'k', 'K';
is_both ["\x4C", '_'], 'l', 'L';
is_both ["\x4D", '_'], 'm', 'M';
is_both ["\x4E", '_'], 'n', 'N';
is_both ["\x4F", '_'], 'o', 'O';
is_both ["\x50", '_'], 'p', 'P';
is_both ["\x51", '_'], 'q', 'Q';
is_both ["\x52", '_'], 'r', 'R';
is_both ["\x53", '_'], 's', 'S';
is_both ["\x54", '_'], 't', 'T';
is_both ["\x55", '_'], 'u', 'U';
is_both ["\x56", '_'], 'v', 'V';
is_both ["\x57", '_'], 'w', 'W';
is_both ["\x58", '_'], 'x', 'X';
is_both ["\x59", '_'], 'y', 'Y';
is_both ["\x5A", '_'], 'z', 'Z';
is_both ["\x5B", '_'], 'left_bracket', 'left_bracket';
is_both ["\x5C", '_'], 'backslash', 'backslash';
is_both ["\x5D", '_'], 'right_bracket', 'right_bracket';
is_both ["\x5E", '_'], 'caret', 'caret';
is_both ["\x5F", '_'], '_', '_';
is_both ["\x60", '_'], 'backtick', 'backtick';
is_both ["\x61", '_'], 'a', 'a';
is_both ["\x62", '_'], 'b', 'b';
is_both ["\x63", '_'], 'c', 'c';
is_both ["\x64", '_'], 'd', 'd';
is_both ["\x65", '_'], 'e', 'e';
is_both ["\x66", '_'], 'f', 'f';
is_both ["\x67", '_'], 'g', 'g';
is_both ["\x68", '_'], 'h', 'h';
is_both ["\x69", '_'], 'i', 'i';
is_both ["\x6A", '_'], 'j', 'j';
is_both ["\x6B", '_'], 'k', 'k';
is_both ["\x6C", '_'], 'l', 'l';
is_both ["\x6D", '_'], 'm', 'm';
is_both ["\x6E", '_'], 'n', 'n';
is_both ["\x6F", '_'], 'o', 'o';
is_both ["\x70", '_'], 'p', 'p';
is_both ["\x71", '_'], 'q', 'q';
is_both ["\x72", '_'], 'r', 'r';
is_both ["\x73", '_'], 's', 's';
is_both ["\x74", '_'], 't', 't';
is_both ["\x75", '_'], 'u', 'u';
is_both ["\x76", '_'], 'v', 'v';
is_both ["\x77", '_'], 'w', 'w';
is_both ["\x78", '_'], 'x', 'x';
is_both ["\x79", '_'], 'y', 'y';
is_both ["\x7A", '_'], 'z', 'z';
is_both ["\x7B", '_'], 'left_brace', 'left_brace';
is_both ["\x7C", '_'], 'pipe_char', 'pipe_char';
is_both ["\x7D", '_'], 'right_brace', 'right_brace';
is_both ["\x7E", '_'], 'tilde', 'tilde';
is_both ["\x7F", '_'], 'delete_char', 'delete_char';

# Test plurals.

is_both ["\x00\x00", '_'], '2_nulls', 'plural null';
is_both ["\x01\x01", '_'], '2_starts_of_heading', 'plural start_of_heading';
is_both ["\x02\x02", '_'], '2_starts_of_text', 'plural start_of_text';
is_both ["\x03\x03", '_'], '2_ends_of_text', 'plural end_of_text';
is_both ["\x04\x04", '_'], '2_ends_of_transmission', 'plural end_of_transmission';
is_both ["\x05\x05", '_'], '2_enquiry_chars', 'plural enquiry_char';
is_both ["\x06\x06", '_'], '2_acknowledges', 'plural acknowledge';
is_both ["\x07\x07", '_'], '2_bell_chars', 'plural bell_char';
is_both ["\x08\x08", '_'], '2_backspaces', 'plural backspace';
is_both ["\x09\x09", '_'], '2_tab_chars', 'plural tab_char';
is_both ["\x0A\x0A", '_'], '2_newlines', 'plural newline';
is_both ["\x0B\x0B", '_'], '2_vertical_tabs', 'plural vertical_tab';
is_both ["\x0C\x0C", '_'], '2_form_feeds', 'plural form_feed';
is_both ["\x0D\x0D", '_'], '2_carriage_returns', 'plural carriage_return';
is_both ["\x0E\x0E", '_'], '2_shifts_out', 'plural shift_out';
is_both ["\x0F\x0F", '_'], '2_shifts_in', 'plural shift_in';
is_both ["\x10\x10", '_'], '2_data_link_escapes', 'plural data_link_escape';
is_both ["\x11\x11", '_'], '2_device_control1s', 'plural device_control1';
is_both ["\x12\x12", '_'], '2_device_control2s', 'plural device_control2';
is_both ["\x13\x13", '_'], '2_device_control3s', 'plural device_control3';
is_both ["\x14\x14", '_'], '2_device_control4s', 'plural device_control4';
is_both ["\x15\x15", '_'], '2_negative_acknowledges', 'plural negative_acknowledge';
is_both ["\x16\x16", '_'], '2_synchronous_idles', 'plural synchronous_idle';
is_both ["\x17\x17", '_'], '2_ends_of_transmission_block', 'plural end_of_transmission_block';
is_both ["\x18\x18", '_'], '2_cancel_chars', 'plural cancel_char';
is_both ["\x19\x19", '_'], '2_ends_of_medium', 'plural end_of_medium';
is_both ["\x1A\x1A", '_'], '2_substitute_chars', 'plural substitute_char';
is_both ["\x1B\x1B", '_'], '2_escape_chars', 'plural escape_char';
is_both ["\x1C\x1C", '_'], '2_file_separators', 'plural file_separator';
is_both ["\x1D\x1D", '_'], '2_group_separators', 'plural group_separator';
is_both ["\x1E\x1E", '_'], '2_record_separators', 'plural record_separator';
is_both ["\x1F\x1F", '_'], '2_unit_separators', 'plural unit_separator';
is_both ["\x20\x20", '_'], '2_space_chars', 'plural space_char';
is_both ["\x21\x21", '_'], '2_exclamation_marks', 'plural exclamation_mark';
is_both ["\x22\x22", '_'], '2_double_quotes', 'plural double_quote';
is_both ["\x23\x23", '_'], '2_hash_marks', 'plural hash_mark';
is_both ["\x24\x24", '_'], '2_dollar_signs', 'plural dollar_sign';
is_both ["\x25\x25", '_'], '2_percent_signs', 'plural percent_sign';
is_both ["\x26\x26", '_'], '2_ampersands', 'plural ampersand';
is_both ["\x27\x27", '_'], '2_single_quotes', 'plural single_quote';
is_both ["\x28\x28", '_'], '2_left_parens', 'plural left_paren';
is_both ["\x29\x29", '_'], '2_right_parens', 'plural right_paren';
is_both ["\x2A\x2A", '_'], '2_asterisks', 'plural asterisk';
is_both ["\x2B\x2B", '_'], '2_plus_signs', 'plural plus_sign';
is_both ["\x2C\x2C", '_'], '2_commas', 'plural comma';
is_both ["\x2D\x2D", '_'], '2_dashes', 'plural dash';
is_both ["\x2E\x2E", '_'], '2_dots', 'plural dot';
is_both ["\x2F\x2F", '_'], '2_slashes', 'plural slash';
is_both ["\x30\x30", '_'], '00', 'plural digit zero';
is_both ["\x31\x31", '_'], '11', 'plural digit one';
is_both ["\x32\x32", '_'], '22', 'plural digit two';
is_both ["\x33\x33", '_'], '33', 'plural digit three';
is_both ["\x34\x34", '_'], '44', 'plural digit four';
is_both ["\x35\x35", '_'], '55', 'plural digit five';
is_both ["\x36\x36", '_'], '66', 'plural digit six';
is_both ["\x37\x37", '_'], '77', 'plural digit seven';
is_both ["\x38\x38", '_'], '88', 'plural digit eight';
is_both ["\x39\x39", '_'], '99', 'plural digit nine';
is_both ["\x3A\x3A", '_'], '2_colons', 'plural colon';
is_both ["\x3B\x3B", '_'], '2_semicolons', 'plural semicolon';
is_both ["\x3C\x3C", '_'], '2_left_angle_brackets', 'plural left_angle_bracket';
is_both ["\x3D\x3D", '_'], '2_equals_signs', 'plural equals_sign';
is_both ["\x3E\x3E", '_'], '2_right_angle_brackets', 'plural right_angle_bracket';
is_both ["\x3F\x3F", '_'], '2_question_marks', 'plural question_mark';
is_both ["\x40\x40", '_'], '2_at_signs', 'plural at_sign';
is_both ["\x41\x41", '_'], 'aA', 'plural A';
is_both ["\x42\x42", '_'], 'bB', 'plural B';
is_both ["\x43\x43", '_'], 'cC', 'plural C';
is_both ["\x44\x44", '_'], 'dD', 'plural D';
is_both ["\x45\x45", '_'], 'eE', 'plural E';
is_both ["\x46\x46", '_'], 'fF', 'plural F';
is_both ["\x47\x47", '_'], 'gG', 'plural G';
is_both ["\x48\x48", '_'], 'hH', 'plural H';
is_both ["\x49\x49", '_'], 'iI', 'plural I';
is_both ["\x4A\x4A", '_'], 'jJ', 'plural J';
is_both ["\x4B\x4B", '_'], 'kK', 'plural K';
is_both ["\x4C\x4C", '_'], 'lL', 'plural L';
is_both ["\x4D\x4D", '_'], 'mM', 'plural M';
is_both ["\x4E\x4E", '_'], 'nN', 'plural N';
is_both ["\x4F\x4F", '_'], 'oO', 'plural O';
is_both ["\x50\x50", '_'], 'pP', 'plural P';
is_both ["\x51\x51", '_'], 'qQ', 'plural Q';
is_both ["\x52\x52", '_'], 'rR', 'plural R';
is_both ["\x53\x53", '_'], 'sS', 'plural S';
is_both ["\x54\x54", '_'], 'tT', 'plural T';
is_both ["\x55\x55", '_'], 'uU', 'plural U';
is_both ["\x56\x56", '_'], 'vV', 'plural V';
is_both ["\x57\x57", '_'], 'wW', 'plural W';
is_both ["\x58\x58", '_'], 'xX', 'plural X';
is_both ["\x59\x59", '_'], 'yY', 'plural Y';
is_both ["\x5A\x5A", '_'], 'zZ', 'plural Z';
is_both ["\x5B\x5B", '_'], '2_left_brackets', 'plural left_bracket';
is_both ["\x5C\x5C", '_'], '2_backslashes', 'plural backslash';
is_both ["\x5D\x5D", '_'], '2_right_brackets', 'plural right_bracket';
is_both ["\x5E\x5E", '_'], '2_carets', 'plural caret';
is_both ["\x5F\x5F", '_'], '__', 'plural _';
is_both ["\x60\x60", '_'], '2_backticks', 'plural backtick';
is_both ["\x61\x61", '_'], 'aa', 'plural a';
is_both ["\x62\x62", '_'], 'bb', 'plural b';
is_both ["\x63\x63", '_'], 'cc', 'plural c';
is_both ["\x64\x64", '_'], 'dd', 'plural d';
is_both ["\x65\x65", '_'], 'ee', 'plural e';
is_both ["\x66\x66", '_'], 'ff', 'plural f';
is_both ["\x67\x67", '_'], 'gg', 'plural g';
is_both ["\x68\x68", '_'], 'hh', 'plural h';
is_both ["\x69\x69", '_'], 'ii', 'plural i';
is_both ["\x6A\x6A", '_'], 'jj', 'plural j';
is_both ["\x6B\x6B", '_'], 'kk', 'plural k';
is_both ["\x6C\x6C", '_'], 'll', 'plural l';
is_both ["\x6D\x6D", '_'], 'mm', 'plural m';
is_both ["\x6E\x6E", '_'], 'nn', 'plural n';
is_both ["\x6F\x6F", '_'], 'oo', 'plural o';
is_both ["\x70\x70", '_'], 'pp', 'plural p';
is_both ["\x71\x71", '_'], 'qq', 'plural q';
is_both ["\x72\x72", '_'], 'rr', 'plural r';
is_both ["\x73\x73", '_'], 'ss', 'plural s';
is_both ["\x74\x74", '_'], 'tt', 'plural t';
is_both ["\x75\x75", '_'], 'uu', 'plural u';
is_both ["\x76\x76", '_'], 'vv', 'plural v';
is_both ["\x77\x77", '_'], 'ww', 'plural w';
is_both ["\x78\x78", '_'], 'xx', 'plural x';
is_both ["\x79\x79", '_'], 'yy', 'plural y';
is_both ["\x7A\x7A", '_'], 'zz', 'plural z';
is_both ["\x7B\x7B", '_'], '2_left_braces', 'plural left_brace';
is_both ["\x7C\x7C", '_'], '2_pipe_chars', 'plural pipe_char';
is_both ["\x7D\x7D", '_'], '2_right_braces', 'plural right_brace';
is_both ["\x7E\x7E", '_'], '2_tildes', 'plural tilde';
is_both ["\x7F\x7F", '_'], '2_delete_chars', 'plural delete_char';

sub to_ascii {
    return String::ToIdentifier::EN::to_identifier(@_)
}

sub to_unicode {
    return String::ToIdentifier::EN::Unicode::to_identifier(@_)
}

sub is_both {
    my @args = @{ +shift };
    my ($expected, $test_name) = @_;

    is to_ascii(@args),   $expected, $test_name;
    is to_unicode(@args), $expected, $test_name;
}
