# Generated by default/object.tt
package Paws::IoTEvents::InputIdentifier;
  use Moose;
  has IotEventsInputIdentifier => (is => 'ro', isa => 'Paws::IoTEvents::IotEventsInputIdentifier', request_name => 'iotEventsInputIdentifier', traits => ['NameInRequest']);
  has IotSiteWiseInputIdentifier => (is => 'ro', isa => 'Paws::IoTEvents::IotSiteWiseInputIdentifier', request_name => 'iotSiteWiseInputIdentifier', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::InputIdentifier

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::InputIdentifier object:

  $service_obj->Method(Att1 => { IotEventsInputIdentifier => $value, ..., IotSiteWiseInputIdentifier => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::InputIdentifier object:

  $result = $service_obj->Method(...);
  $result->Att1->IotEventsInputIdentifier

=head1 DESCRIPTION

The identifer of the input.

=head1 ATTRIBUTES


=head2 IotEventsInputIdentifier => L<Paws::IoTEvents::IotEventsInputIdentifier>

The identifier of the input routed to AWS IoT Events.


=head2 IotSiteWiseInputIdentifier => L<Paws::IoTEvents::IotSiteWiseInputIdentifier>

The identifer of the input routed from AWS IoT SiteWise.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

