package Dist::Zilla::App::Command::generate_spec;
# ABSTRACT: generate RPM spec file from your template

use strict;
use warnings;
use Carp;

use Dist::Zilla::App -command;

our $VERSION = '0.009'; # VERSION

sub abstract { 'generate RPM spec file from your build template' }

sub execute {
    my($self,$opt,$args) = @_;
    my($filename) = @{$args};
    $filename ||= 'dzil.spec';

    require Path::Class;

    $_->before_build     for @{ $self->zilla->plugins_with(-BeforeBuild) };
    $_->gather_files     for @{ $self->zilla->plugins_with(-FileGatherer) };
    $_->prune_files      for @{ $self->zilla->plugins_with(-FilePruner) };
    $_->register_prereqs for @{ $self->zilla->plugins_with(-PrereqSource) };

    my $outfile = Path::Class::File->new($filename);
    my $out = $outfile->openw;
    print $out $self->zilla->plugin_named('RPM::Push')->mk_spec(
        sprintf('%s-%s.tar.gz',$self->zilla->name,$self->zilla->version)
    );

    $self->log("spec file written to $outfile");
}

1;

__END__
=pod

=head1 SYNOPSIS

  dzil generate_spec [filename]

=head1 DESCRIPTION

This command writes a parsed version of the spec file that would be generated by
L<Dist::Zilla::Plugin::RPM::Push|Dist::Zilla::Plugin::RPM::Push> during release, without
having to do a full release. This is useful for testing or tweaking your RPM
build without having to run dzil each time.

=head1 EXAMPLE

  $ dzil generate_spec
  $ dzil generate_spec /path/to/foo.spec

=head1 OPTIONS

=head2 filename (default: "./dzil.spec")

The filename to write the specfile to.

=cut
