# Generated by default/object.tt
package Paws::MediaLive::FeatureActivations;
  use Moose;
  has InputPrepareScheduleActions => (is => 'ro', isa => 'Str', request_name => 'inputPrepareScheduleActions', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::FeatureActivations

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::FeatureActivations object:

  $service_obj->Method(Att1 => { InputPrepareScheduleActions => $value, ..., InputPrepareScheduleActions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::FeatureActivations object:

  $result = $service_obj->Method(...);
  $result->Att1->InputPrepareScheduleActions

=head1 DESCRIPTION

Feature Activations

=head1 ATTRIBUTES


=head2 InputPrepareScheduleActions => Str

Enables the Input Prepare feature. You can create Input Prepare actions
in the schedule only if this feature is enabled. If you disable the
feature on an existing schedule, make sure that you first delete all
input prepare actions from the schedule.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

